### **Overview**

- **Policies** in Cisco Umbrella are the foundation for defining **security** and **access controls** applied to **identities**.
- **Identities** represent internet-enabled entities (e.g., networks, users) that Umbrella protects through policies.
- Policies determine whether traffic is **inspected**, **blocked**, or **allowed**.

---

### **Key Features of Cisco Umbrella Policies**

- Multiple policies can be created and applied to different identities.
- Identities can belong to **more than one policy**, allowing flexible and customized security controls.
- Four main **policy types** are available in Cisco Umbrella.

---

### **Cisco Umbrella Policy Types**
![[Pasted image 20250512110043.png]]

#### **1. DNS Policy**

- Provides **DNS-layer visibility**, **security**, and **enforcement**.
- Can selectively **proxy risky domains** for added security.

#### **2. Firewall Policy**

- Offers **cloud-delivered firewall (CDFW)** services without needing physical or virtual appliances.
- Logs all network activity and blocks unwanted traffic using:
    - **IP**, **port**, and **protocol rule criteria**.
- Includes Cisco **Intrusion Prevention System (IPS)** settings to detect or block threats.

#### **3. Web Policy**

- Provides **URL-layer visibility**, **security**, and **enforcement** of web traffic.
- Configures **rulesets** for permissions, access, and security controls.

#### **4. Data Loss Prevention (DLP) Policy**

- Protects **sensitive data** that is stored or shared in **cloud applications**.
- Prevents unauthorized data uploads to the web.

---

### **Cisco Umbrella Identity Types**

Cisco Umbrella identifies entities using the following methods:

- **Public IP address**
- **Internal IP address** and **hostname**
- **Network device information**
- **IPsec (IKEv2) tunnel authentication**
- **SAML (Security Assertion Markup Language)**
- **Active Directory users and groups**
- **Google G Suite identities**

---

### **Deployment and Identity Types**

| **Deployment Type**                       | **Identity Applied To**                        | **Applicable Policies**         |
| ----------------------------------------- | ---------------------------------------------- | ------------------------------- |
| **PAC file**                              | Networks, Users, and Groups                    | Web Policy only                 |
| **Proxy chaining**                        | Networks, Users, and Groups                    | Web Policy only                 |
| **IPsec tunnel**                          | Network Tunnels, Users, and Groups             | DLP, Firewall, and Web Policies |
| **Secure Client Roaming Security Module** | Networks, Roaming Computers, Users, and Groups | DNS and Web Policies            |
| **Umbrella mobile client app**            | Networks, Mobile Clients                       | DNS Policy only                 |
| **Network device**                        | Networks, Network Devices                      | DNS Policy only                 |
| **Internal network**                      | Networks, Internal Networks                    | DNS Policy only                 |
| **Chromebook client**                     | Chromebook Users, G Suite                      | DNS Policy only                 |
| **Virtual Appliance**                     | Sites, Internal Networks, Users, and Groups    | DNS Policy only                 |

---

### **Packet Flow Through Cisco Umbrella Policies**

![[Pasted image 20250512110933.png]]

![[Pasted image 20250512112002.png]]

When all Umbrella policies (DNS, Firewall, Web, and DLP) are enabled, the packet flow follows this sequence:

1. **DNS Policy**:
    
    - **First check** for malicious or unwanted domains.
    - Blocks threats at the DNS layer, reducing traffic sent to the firewall and secure web gateway (SWG).

2. **Firewall Policy**:
    - Inspects all outbound internet traffic across **all ports and protocols**.
    - Blocks or allows traffic based on IP, port, and protocol rules.
    - **CDFW** - **Cloud Delivered Firewall**

3. **Web Policy (Secure Web Gateway - SWG)**:
    - Inspects web traffic for:
        - **Content control policies**.
        - **Malware detection**.
        - **Other policy violations**.

4. **CASB (Cloud Access Security Broker) and DLP Policies**:
    - Ensures **application behavior** complies with corporate standards.
    - **DLP checks** prevent sensitive data from being leaked.
    - Scans data at rest for malware and enforces SaaS-related compliance.


